function [out,theta]=SimulateCVineNC(data,T)
% code to simulate a canonical vine based on bivariate normal copula
% INPUTS:
% data: A matrix of U(0,1) variables or a positive integer. In case you
% provide a matrix, the parameters in theta will be equal to the sample
% parameters from data, for example the parameter of the C24|1, which is
% the partial correlation of variables 2 and 4, given 1, will be equal to
% the partial correlation of columns 2 and 4, given column 1, from the data.
% If you provide a positive integer, the theta parameters will also be
% simulated.
% T: The size of the simulated data (number of rows)
% OUTPUTS:
% out: The simulated data
% ------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2008 - 2009
% contact at: vogia@yahoo.com

% simulate the parameters theta of the CVine
if isscalar(data)==1
[CVine,theta]=CVineStruct(data); % create theta parameters
N=data;
else
[CVine,theta]=CVineStruct(data); % create theta parameters
N=size(data,2);
end
%simulate independend uniform variates
w=copularnd('Gaussian',eye(N),T); 
out=zeros(size(w));
out(:,1)=w(:,1);
u=cell(N,N);
u{1,1}=w(:,1);
for i=2:N
    u{i,1}=w(:,i);
    l=linspace(i-1,1,i-1); s=length(l);
    for k=1:s
        u{i,1}=invhfuncNC(u{i,1},u{l(k),l(k)},theta{l(k),i-l(k)});
    end
    out(:,i)=u{i,1};
    for j=1:(i-1)
        u{i,j+1}=hfuncNC(u{i,j},u{j,j},theta{j,i-j});
    end
end
    
    


